package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.json.EventHistoryView;
import gov.va.vinci.dart.json.EventRequestView;

import java.util.List;

public class EventHistoryViewBuilder {

	EventRequestViewBuilder eventRequestViewBuilder = new EventRequestViewBuilder();
	
	public EventHistoryView build(final List<EventSummary> eventSummaryList) {
		EventHistoryView result = new EventHistoryView();
		
		int lastRequestId = -1;
		
		for (EventSummary summary : eventSummaryList) {
			if (lastRequestId != summary.getRequestId()) {
				lastRequestId = summary.getRequestId();
				
				EventRequestView requestView = eventRequestViewBuilder.build(eventSummaryList, lastRequestId);
				result.getRequests().add(requestView);
			}
		}
		
		return result;
	}
}
